package net.w_horse.excelpojo.converter;

import static org.junit.Assert.assertEquals;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.converter.AnnotationConverter;
import test.converter.AnnotationConverterPriority;


public class AnnotationConverterTest extends AbstractTest {
	/**
	 * Ame[Vɂt^̃tH[}bg̍كeXg
	 * @throws ParseException
	 *
	 */
	@Test
	public void testConverterDateFormat() throws ExcelPOJOException, IOException, ParseException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationConverter.class);
		AnnotationConverter targetBean = (AnnotationConverter) bridge.load("./files/upload/ParserTest.xls", "ϊ");

		assertEquals("ϊ Data01", (new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-05")),targetBean.getDate1());
		assertEquals("ϊ DateStr01", "2010N0806",targetBean.getDateStr1());
		assertEquals("ϊ DateStr02", "2010N0807",targetBean.getDateStr2());

		assertEquals("ϊ boolean01", true, targetBean.isBoolean1());
		assertEquals("ϊ boolean02", false,targetBean.isBoolean2());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"ϊ",
				"./files/export/AnnotationParserTest_ϊ.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ϊ.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ϊ");

			assertEquals("ϊ Data01", "2010-08-05", getCellValue(sheet, 2, 4, CELL_TYPE_STRING));
			assertEquals("ϊ DateStr01", "2010-08-06", getCellValue(sheet, 3, 4, CELL_TYPE_STRING));
			assertEquals("ϊ DateStr02", (new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-07")), getCellValue(sheet, 4, 4, CELL_TYPE_DATE));

			assertEquals("ϊ boolean01", "true", getCellValue(sheet, 5, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean02", "false", getCellValue(sheet, 6, 4, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML̒`Ame[VD悷邱ƂmF
	 * @throws ExcelPOJOException
	 * @throws IOException
	 * @throws ParseException
	 */
	@Test
	public void testConverterXMLPriorityThanAnnotation() throws ExcelPOJOException, IOException, ParseException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testConverterXMLPriorityThanAnnotation.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testConverterXMLPriorityThanAnnotation");
		AnnotationConverterPriority targetBean = (AnnotationConverterPriority) bridge.load("./files/upload/ParserTest.xls", "ϊ");

		assertEquals("ϊ Data01", (new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-05")),targetBean.getDate1());
		assertEquals("ϊ DateStr01", "20100806",targetBean.getDateStr1());
		assertEquals("ϊ DateStr02", "2010N0806",targetBean.getDateStr2());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"ϊ",
				"./files/export/AnnotationParserTest_ϊXMLPriority.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ϊXMLPriority.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ϊ");

			assertEquals("ϊ Data01", "2010-08-05", getCellValue(sheet, 2, 4, CELL_TYPE_STRING));
			assertEquals("ϊ DateStr01", "2010/8/6", getCellValue(sheet, 17, 4, CELL_TYPE_STRING));
			assertEquals("ϊ DateStr02", "2010-08-06", getCellValue(sheet, 3, 4, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

}
